/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

// #include <string.h>
// #include <stdio.h>
//#include <stdlib.h>

#include "drmcommon.h"
#include "drmutilities.h"
#include "drmcontextsizes.h"
#include "drmliceval.h"
#include "drmexpreval.h"
#include "drmheaderparser.h"
#include "drmlicenseparser.h"

#include "drmmanager.h"
#include "drmpkcrypto.h"
#include "drmlicacq.h"
#include "drmcipher.h"
#include "drmblackbox.h"
#if DRM_SUPPORT_APP_REVOCATION
	#include <drmrevocation.h>
#endif
#include "drmviewprops.h"
#include "drmcrt.h"

#include "tOEMIMP.h"

#include "tclib.h"
#include "LicEval.h"
#include "Licenses.h"
#include "tstutils.h"
#include "teststubcerts.h"
#include "DX_VOS_Utils.h"

#define ASSIGN_WSTR_TO_DRMSTRING(x,y) {(x).pwszString=(y);(x).cchString=DRM_wcslen(y);}

static const char _devcerttemplate[] = "devcerttemplate.dat";
static DRM_WCHAR devcerttemplate[sizeof(_devcerttemplate) + 1];

static const char _priv[] = "priv.dat";
static DRM_WCHAR priv[sizeof(_priv) + 1];

static const char _wszHeader[] = "<WRMHEADER version=\"2.0.0.0\"><DATA><LAINFO>http://v2srv/WM/getv2lic.asp</LAINFO><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><CHECKSUM>oA7EpBNu3g==</CHECKSUM><CID>3</CID><NAME>V2_5sec.wma</NAME></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>QrUgBBheJVzAOOw2kbo*1sqJkwft4oXKNBPv56PpUhho5fS6XK6sTg==</VALUE></SIGNATURE></WRMHEADER>";
static DRM_WCHAR wszHeader[sizeof(_wszHeader) + 1/*390*/];

static const char _wszDefaultHeader[] = "<WRMHEADER version=\"2.0.0.0\"><DATA><LAINFO>http://kganesan1/wm/getv2lic.asp?WMPFriendly=1</LAINFO><KID>NtU91UHN0xGLYgDAT3nsdQ==</KID><CHECKSUM>tYxiHBckHg==</CHECKSUM><CID>1</CID><SECURITYVERSION>2.0.0.0</SECURITYVERSION><OWNER><NAME>Elvis</NAME><ID>123</ID></OWNER></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>vxdNIqchmBJsa00ibiYqWB59UDMeg0N6ULlKdDpGjVKVbSdegQwwTg==</VALUE></SIGNATURE></WRMHEADER>";
static DRM_WCHAR wszDefaultHeader[sizeof(_wszDefaultHeader) + 1/*472*/];

static const char _g_wcszInvalidBB_VERSION_STRING[] = "1.0.0.0";
static DRM_WCHAR g_wcszInvalidBB_VERSION_STRING[sizeof(_g_wcszInvalidBB_VERSION_STRING) + 1];
static const char _g_wcszInvalidDRM_VERSION_STRING[] = "1.0.0.1";
static DRM_WCHAR g_wcszInvalidDRM_VERSION_STRING[sizeof(_g_wcszInvalidDRM_VERSION_STRING) + 1];

static const char _InvalidrgbLID[] = "{11117A28-3AAA-7777-AF13-F77A5258A9F1}";
static DRM_WCHAR InvalidrgbLID[sizeof(_InvalidrgbLID) + 1/*40*/];
static const char _InvalidrgbKID[] = "1111Sn1czUaZpE4OPSbZbg==";
static DRM_WCHAR InvalidrgbKID[sizeof(_InvalidrgbKID) + 1/*26*/];

static const char _wszLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAABHnuWu69pRyZdeXjZXr4JZk2xSEmij3MFnPjIXIwvHWZNKoouCVINgVWFIY4OXRRTFYhONF455W9o5!gbPlNB50yKXGyMeBnPkg*FGf1aaNxQECB8AAAAJAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAAAc0PxXzxT372KnwUj4GAV4NszqN7TigP1iBVL!XpSor!osxfFC!U4i7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQEBRQAADQTAAAAAgAAbUM=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAABHnuWu69pRyZdeXjZXr4JZk2xSEmij3MFnPjIXIwvHWZNKoouCVINgVWFIY4OXRRTFYhONF455W9o5!gbPlNB50yKXGyMeBnPkg*FGf1aaNxQECB8AAAAJAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAAAc0PxXzxT372KnwUj4GAV4NszqN7TigP1iBVL!XpSor!osxfFC!U4i7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQEBRQAADQTAAAAAgAAbUM=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszLicense[sizeof(_wszLicense) + 1/*2906*/];

static const char _wszOldLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>";
static DRM_WCHAR wszOldLicense[sizeof(_wszOldLicense) + 1/*2032*/];

static const char _wszInvalidLicense[] = "<LICENSE version=\"1.0.1.0\"><LICENSORINFO><DATA><LID>{11117A28-3FEE-7777-AF13-F77A5258A9F1}</LID><KID>1111Sn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>";
static DRM_WCHAR wszInvalidLicense[sizeof(_wszInvalidLicense) + 1/*2602*/];

static const char _wszNOStoreRightLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszNOStoreRightLicense[sizeof(_wszNOStoreRightLicense) + 1/*2494*/];

static const char _wszNOSelectRightLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszNOSelectRightLicense[sizeof(_wszNOSelectRightLicense) + 1/*5634*/];

static const char _wszNODeleteRightLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszNODeleteRightLicense[sizeof(_wszNODeleteRightLicense)+1];


DRM_HDS_CONTEXT *g_pHdsContext = NULL;

/*
argv[0]: iOptions: the field of the LicEvalContext to be overwritten
argv[1]: instruction for this field: valid, wrong, invalid, NULL

iOptions:
	0.  all valid fields
	1.  pCryptoContext;
    2.  ExprEvalContext;
    3.  dstrContentHeader;
    4.  dstrContentLicense;
    5.  dstrBBVer;
    6.  dstrDRMVer;
    7.  pcontextSSTLicense;
    8.  pcontextSSTGlobal;
    9.  pcontextSSTRevocation;
    12. rgbLID;
    13. rgbKID;
    14. fGlobalSecStoreWritable;
    15. dwFlags;			( Default as this LICEVAL_OPEN_CHECK_SETTINGS )
    16. pbBuffer;			( User gives a point to work in.  This is actually going to be used for revocation from the secure store ) 
    17. cbBuffer;			( Size of the user supplied pointer   )  
    18. fReserved;			( Must be initialized to 0           )
	19. SecureStoreGlobalPassword ( Talk to blackbox to get the global secure store password )
*/

DRM_RESULT TestLicEvalContextSetting(long argc, char **argv)
{
	int iOptions = 0;
	int idx;
	DRM_BYTE rgbBuffer[MAX_DEVICE_CERT_SIZE];    
    DRM_CONST_STRING dstrDevCert;    
	DRM_CONST_STRING wszValue;
	DRM_BYTE szOEMGlobalPassword[SHA_DIGEST_LEN], szSecStorePassword[SHA_DIGEST_LEN];

	Log("Trace", "From TestLicEvalContextSetting, argc = %d", argc);

    DSTR_FROM_PB( &dstrDevCert, rgbBuffer, SIZEOF(rgbBuffer) );

	for(idx=0; idx<argc; idx++){
		Log("Trace", "From TestLicEvalContextSetting: argv[%d]=%s", idx, argv[idx]);
	}
	ChkArg(argc > 1);

	iOptions = OEM_atoi(argv[0]);
	
	DX_VOS_MemSet( &(Context), 0, sizeof( DRM_LICEVAL_CONTEXT ) );

	if (iOptions != 15) /* dwFlags: Default as this LICEVAL_OPEN_CHECK_SETTINGS */
		Context.dwFlags = LICEVAL_OPEN_CHECK_SETTINGS;    
	else if (!argv[1])
		Context.dwFlags =  0;
	else if(!DX_VOS_StrCmp(argv[1],"valid"))
		Context.dwFlags = LICEVAL_STORE_CHECK_SETTINGS;
	else if (!DX_VOS_StrCmp(argv[1],"invalid"))               
		Context.dwFlags = LICEVAL_OPEN_CHECK_SETTINGS | 8;

	/* 1. CryptoContext */
	if(iOptions!=1)
		Context.pcontextBBX = &oBBContext; 
	else             /* NULL CryptoContext */
		Context.pcontextBBX = NULL;

	/*blackbox initialized */
    ChkDR( DRM_DDC_GetDeviceCertificate( (DRM_STRING*)&dstrDevCert, 0, &oBBContext.CryptoContext ) );
    ChkDR( DRM_DCP_LoadPropertiesCache( &dstrDevCert, &oBBContext.cachedCertValues, &oBBContext.CryptoContext ) );
    ChkDR( DRM_BBX_Initialize( &oBBContext ) );

	ChkDR( DRM_DCP_GetAttribute( &dstrDevCert, DRM_DEVCERT_GROUPSECURITYLEVEL, NULL, &wszValue) );
	DRMCRT_wcsntol( wszValue.pwszString, wszValue.cchString,(DRM_LONG*) &appSec ) ;
	ChkDR( DRM_DCP_GetAttribute( &dstrDevCert, DRM_DEVCERT_SUBJECTID, NULL, &wszValue) );
	DRMCRT_wcsntol( wszValue.pwszString, wszValue.cchString, (DRM_LONG*)&appcd_subject );

	ChkDR(DRM_BBX_Initialize(&oBBContext));

	if(iOptions!=3) {      
		DX_VOS_Utf8ToUtf16(wszHeader, sizeof(_wszHeader)*sizeof(DRM_WCHAR), _wszHeader);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentHeader, wszHeader );
	} else if (argv[1])	{ /* 3.  dstrContentHeader; */
		if(!DX_VOS_StrCmp(argv[1],"DefaultContentHeader")) {
			DX_VOS_Utf8ToUtf16(wszDefaultHeader, sizeof(_wszDefaultHeader)*sizeof(DRM_WCHAR), _wszDefaultHeader);
			ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentHeader, wszDefaultHeader );
		}
	}

	if(iOptions!=4) {     /* 4.  dstrContentLicense; */
		DX_VOS_Utf8ToUtf16(wszLicense, sizeof(_wszLicense)*sizeof(DRM_WCHAR), _wszLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense, wszLicense );
	} else if (!argv[1])
		Context.dstrContentLicense.pwszString = NULL;
	else if(!DX_VOS_StrCmp(argv[1],"wszOldLicense")) {
		DX_VOS_Utf8ToUtf16(wszOldLicense, sizeof(_wszOldLicense)*sizeof(DRM_WCHAR), _wszOldLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense, wszOldLicense);
	} else if(!DX_VOS_StrCmp(argv[1],"wszInvalidLicense")) {
		DX_VOS_Utf8ToUtf16(wszInvalidLicense, sizeof(_wszInvalidLicense)*sizeof(DRM_WCHAR), _wszInvalidLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense, wszInvalidLicense );
	} else if(!DX_VOS_StrCmp(argv[1],"NOStoreRight")) {
		DX_VOS_Utf8ToUtf16(wszNOStoreRightLicense, sizeof(_wszNOStoreRightLicense)*sizeof(DRM_WCHAR), _wszNOStoreRightLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense,wszNOStoreRightLicense );
	} else if(!DX_VOS_StrCmp(argv[1],"NOSelectRight"))	{
		DX_VOS_Utf8ToUtf16(wszNOSelectRightLicense, sizeof(_wszNOSelectRightLicense)*sizeof(DRM_WCHAR), _wszNOSelectRightLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense,wszNOSelectRightLicense );
	} else if(!DX_VOS_StrCmp(argv[1],"NODeleteRight"))	{
		DX_VOS_Utf8ToUtf16(wszNODeleteRightLicense, sizeof(_wszNODeleteRightLicense)*sizeof(DRM_WCHAR), _wszNODeleteRightLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense,wszNODeleteRightLicense );
	}

	/* 13. rgbKID; */
	if(iOptions!=13) {
		ChkDR( DRM_HDR_GetAttribute(&(Context.dstrContentHeader), NULL, DRM_HEADER_ATTRIB_KID, &wszKID, 0) );
	} else if (!argv[1])  /* rgbKID = NULL */
		wszKID.pwszString = NULL;
	else if (!DX_VOS_StrCmp(argv[1],"InvalidKID")) {
		DX_VOS_Utf8ToUtf16(InvalidrgbKID, sizeof(_InvalidrgbKID)*sizeof(DRM_WCHAR), _InvalidrgbKID);
		ASSIGN_WSTR_TO_DRMSTRING( wszKID, InvalidrgbKID );
	}

	/* If the following base64 decode fails because the buffer isn't big enough then it isn't a valid KID anyway. */
	cbKID = sizeof( rgbKID );
	DX_VOS_MemSet( rgbKID, 0, sizeof( rgbKID ) );
	ChkDR( DRM_B64_DecodeW(&wszKID, &cbKID, rgbKID, 0) );
    
	ChkDR( DRM_LST_Open(&oLicStoreContext, g_pHdsContext) );

	/*Talk to blackbox to get the global secure store password */
	/* 19. SecureStoreGlobalPassword */
	if(iOptions!=19) {
		ChkDR(OEM_GetSecureStoreGlobalPasswordSeed(szOEMGlobalPassword));
		ChkDR(DRM_BBX_HashValue( szOEMGlobalPassword, SHA_DIGEST_LEN, szSecStorePassword, &oBBContext));
	} else if (!argv[1])		/* NULL SecureStoreGlobalPassword*/
		DX_VOS_MemSet(szSecStorePassword, 0, SHA_DIGEST_LEN);
	else if(!DX_VOS_StrCmp(argv[1],"InvalidGlobalSecStorePassword"))
		DX_VOS_MemSet(szSecStorePassword, 1, SHA_DIGEST_LEN);

	ChkMem( Context.pcontextSSTGlobal = (DRM_SECSTORE_CONTEXT*) OEM_malloc( sizeof(DRM_SECSTORE_CONTEXT) ) );

	ChkDR( DRM_SST_OpenKeyTokens (
		Context.pcontextSSTGlobal, 
		&g_rgbSecStoreGlobalName, 
		NULL,
		szSecStorePassword, 
		DRM_SECURE_STORE_CREATE_IF_NOT_EXISTS,
		SECURE_STORE_GLOBAL_DATA, 
		g_pHdsContext));
 
	/*add revocation:  revocation store not opened here */
	/* 9. pcontextSSTRevocation */
	if(iOptions!=9) {
		Context.cbRevocationBuffer = 10*1024; //BUGBUG:  MAX_REVOCATION_LIST_SIZE;
		OEM_free(Context.pbRevocationBuffer);
		ChkMem(Context.pbRevocationBuffer = (DRM_BYTE*)OEM_malloc(Context.cbRevocationBuffer));
		DX_VOS_FastMemCpy(&Context.appcert, g_teststubcert, sizeof(APPCERT));

		ChkMem( Context.pcontextSSTRevocation = (DRM_SECSTORE_CONTEXT*) OEM_malloc( sizeof(DRM_SECSTORE_CONTEXT)  ) );
	} else if (!(argv[1]))			/* NULL pcontextSSTRevocation*/
		Context.pcontextSSTRevocation = NULL;

	/* 5. dstrBBVer; */
	if(iOptions!=5)	{		
	    /* The real current version of drm is 2.3.101.0 */
        MEMCPY( bBBVer, oBBContext.cachedCertValues.m_BBCompatibilityCert.pk.version, VERSION_LEN);
		ChkDR( DRM_UTL_GetVersionAsString( bBBVer, wszBBVerString) );
		/*	The legacy compatability version used for license acquisition requests  current for this code is 2.3.0.2
		ChkDR( DRM_BBX_GetLegacyLicenseChallengeVersionString( wszBBVerString, &oBBContext) ); */

		Context.dstrBBVer.pwszString = wszBBVerString;
		Context.dstrBBVer.cchString = (DRM_DWORD)DRM_wcslen(Context.dstrBBVer.pwszString );
	} else if (!(argv[1]))  /* NULL */	{
		Context.dstrBBVer.pwszString = NULL;
		Context.dstrBBVer.cchString =  0;
	} else if(!DX_VOS_StrCmp(argv[1],"invalid"))
	{
		DX_VOS_Utf8ToUtf16(g_wcszInvalidBB_VERSION_STRING, sizeof(_g_wcszInvalidBB_VERSION_STRING)*sizeof(DRM_WCHAR), _g_wcszInvalidBB_VERSION_STRING);
		ASSIGN_WSTR_TO_DRMSTRING(Context.dstrBBVer, g_wcszInvalidBB_VERSION_STRING);
	}

	/* 6.  dstrDRMVer; */
	if(iOptions!=6) {
		Context.dstrDRMVer = g_dstrDRM_VERSION_STRING;
	} else if (!argv[1]) {
		Context.dstrDRMVer.pwszString = NULL;
		Context.dstrDRMVer.cchString = 0;
	} else if (!DX_VOS_StrCmp(argv[1],"invalid")) {
		DX_VOS_Utf8ToUtf16(g_wcszInvalidDRM_VERSION_STRING, sizeof(_g_wcszInvalidDRM_VERSION_STRING)*sizeof(DRM_WCHAR), _g_wcszInvalidDRM_VERSION_STRING);
		ASSIGN_WSTR_TO_DRMSTRING(Context.dstrDRMVer, g_wcszInvalidDRM_VERSION_STRING);
	}

	Context.fGlobalSecStoreWritable = FALSE;

	/* We have a license.  Check the revocation list and app cert */
	/* 9. pcontextSSTRevocation=NULL would crash */
#if DRM_SUPPORT_APP_REVOCATION
	if(iOptions!=9) {
		ChkDR(DRM_RVK_PerformAppRevocationCheck(&Context, g_pHdsContext));
	}
#endif

	/* Get the LID for the license */
	ChkDR( DRM_LIC_GetAttribute( &(Context.dstrContentLicense), NULL, DRM_LICENSE_ATTRIB_LID, NULL, &wszKID, 0 ) );

	if(iOptions==12)			/* 12. rgbLID; */
	{
		if (!argv[1]) {
			wszKID.pwszString = NULL;
			wszKID.cchString = 0;
		} else if(!DX_VOS_StrCmp(argv[1],"invalid")) {
			DX_VOS_Utf8ToUtf16(InvalidrgbLID, sizeof(_InvalidrgbLID)*sizeof(DRM_WCHAR), _InvalidrgbLID);
			ASSIGN_WSTR_TO_DRMSTRING(wszKID, InvalidrgbLID);
		}
	}

	ChkDR( DRM_UTL_StringToGuid( &wszKID, (DRM_GUID*) Context.LID.rgb ) );

	/* 7. pcontextSSTLicense */
	if(iOptions!=7)	{	
		ChkMem( Context.pcontextSSTLicense = (DRM_SECSTORE_CONTEXT*) OEM_malloc( sizeof(DRM_SECSTORE_CONTEXT)  ) );
		ChkDR( DRM_SST_OpenKeyTokens (
			Context.pcontextSSTLicense, 
			&(Context.LID),
			NULL,
			szSecStorePassword, 
			DRM_SECURE_STORE_CREATE_IF_NOT_EXISTS,
			SECURE_STORE_LICENSE_DATA, 
			g_pHdsContext));
	}

	Context.fAppInfoValid = TRUE;
    Context.certinfoSDK.appSec = appSec;
	Context.certinfoSDK.appcd_subject = appcd_subject;

ErrorExit:
	return dr;    /* DRM_SUCCESS; */
}

DRM_RESULT TestLicenseEvalPerformOperations(long argc, char **argv)
{
	int idx;
	DRM_CONST_STRING wszAction = {0};
	DRM_BOOL fPerform, fActionExist;
	eDRM_LICEVAL_OPERATION_STATE eOperationState;
	eDRM_LICEVAL_OPERATIONS eOperation;

	Log("Trace", "From TestLicenseEvalPerformOperations, argc = %d", argc);

	for(idx=0; idx<argc; idx++){
		Log("Trace", "From TestLicenseEvalPerformOperations: argv[%d]=%s", idx, argv[idx]);
	}

	ChkArg(argc > 4);

	if(!argv[0])
		eOperation = 0;
	else if (!DX_VOS_StrCmp(argv[0],"DRM_LICENSE_EVAL_SELECT"))
		eOperation=DRM_LICENSE_EVAL_SELECT;
	else if(!DX_VOS_StrCmp(argv[0],"DRM_LICENSE_EVAL_STORE"))
		eOperation=DRM_LICENSE_EVAL_STORE;
	else if(!DX_VOS_StrCmp(argv[0],"DRM_LICENSE_EVAL_DELETE"))
		eOperation=DRM_LICENSE_EVAL_DELETE;
	else if(!DX_VOS_StrCmp(argv[0],"DRM_LICENSE_EVAL_REPORTCLOCK_ROLLBACK"))
		eOperation=DRM_LICENSE_EVAL_REPORTCLOCK_ROLLBACK;
	else if(!DX_VOS_StrCmp(argv[0],"DRM_LICENSE_EVAL_ACTION"))
		eOperation=DRM_LICENSE_EVAL_ACTION;
	else
		eOperation = OEM_atoi(argv[0]);

	if(!argv[1])
		eOperationState = 0;
	else if(!DX_VOS_StrCmp(argv[1],"DRM_LICENSE_EVAL_CAN_DO_OPERATION"))
		eOperationState=DRM_LICENSE_EVAL_CAN_DO_OPERATION;
	else if(!DX_VOS_StrCmp(argv[1],"DRM_LICENSE_EVAL_DONE_WITH_OPERATION"))
		eOperationState=DRM_LICENSE_EVAL_DONE_WITH_OPERATION;
	else
		eOperationState = OEM_atoi(argv[1]);

	MakeDRMString(&wszAction, argv[2]);

	dr = DRM_LEVL_PerformOperations(
		argv[3]? &Context:NULL, 
		eOperation, 
		eOperationState, 
		argv[2]? &wszAction: NULL, 
		argv[4]? &fPerform: NULL,
		&fActionExist,
		g_pHdsContext);
ErrorExit:
	DX_VOS_MemFree((DRM_WCHAR*)wszAction.pwszString);
	return dr;
}

DRM_RESULT LE_PreTestCase(long lTCID, char *strTCName)
{
	DRM_RESULT dr;
	DRM_CONST_STRING wszHDSPath;

	DX_VOS_MemSet( &Context, 0, sizeof( DRM_LICEVAL_CONTEXT ) );
	RemoveDRMFile(RMFILE_ALL);
	DX_VOS_Utf8ToUtf16(devcerttemplate, sizeof(_devcerttemplate)*sizeof(DRM_WCHAR), _devcerttemplate);
	DX_VOS_Utf8ToUtf16(priv, sizeof(_priv)*sizeof(DRM_WCHAR), _priv);
	ChkDR(SetDeviceEnv(devcerttemplate, priv, TRUE));
	RemoveDRMFile(RMFILE_STORE);
	tGetDeviceStorePathname(&wszHDSPath);
	ChkDR(OpenHDS(&g_pHdsContext, wszHDSPath.pwszString, TRUE));
ErrorExit:
	return dr;
}

DRM_RESULT LE_PostTestCase(long lTCID, char *strTCName)
{
	DRM_LST_Close(&oLicStoreContext);
	DRM_SST_CloseKey(Context.pcontextSSTGlobal, g_pHdsContext);
	DRM_SST_CloseKey(Context.pcontextSSTLicense, g_pHdsContext);

	OEM_free(Context.pcontextSSTGlobal);
	OEM_free(Context.pcontextSSTLicense);
	OEM_free(Context.pcontextSSTRevocation );
	OEM_free(Context.pbRevocationBuffer);
	DX_VOS_MemSet( &Context, 0, sizeof( DRM_LICEVAL_CONTEXT ) );
	DX_VOS_MemSet( &oBBContext, 0, sizeof( DRM_BB_CONTEXT ) );

	CloseHDS(g_pHdsContext);
	g_pHdsContext = NULL;

	return DRM_SUCCESS;
}

/*
IMPLEMENT_DEFAULT_WARPTEST

BEGIN_APIMAP(RefTestLicEval_ansi, "LicEval") 
 	API_ENTRY(TestLicEvalContextSetting)
	API_ENTRY(TestLicenseEvalPerformOperations)
END_APIMAP
*/
